#!/usr/bin/perl

use strict;
use Getopt::Std;
use Cwd;

my @replace=();
my $opt_f = "";
my $dir = getcwd;
my $verbose = 0;
my $recursive = 0;
my $top = 0;

while (my $arg = shift @ARGV) {
  if ($arg =~ /^-t$/g) { $top = 1;} #insert at beginning
  if ($arg =~ /^-r$/g) { $recursive = 1;}  #recursive
  if ($arg =~ /^-v$/g) { $verbose = 1;}  #verbose output
  if ($arg =~ /^-d$/g) { $dir = shift @ARGV;}  #directory
  if ($arg =~ /^-b$/g) { @replace = getBlock(shift @ARGV);} #replace with entire block from file
  if ($arg =~ /^-f$/g) { $opt_f = shift @ARGV;} #file to search in
}
my @files=split(/,/,$opt_f);

&Usage unless (length($dir) > 0);
&Usage unless (length($opt_f) > 0);

&append($dir,$verbose,\@files,\@replace);

sub append {
  my ($dir,$verbose,$ptrfiles,$ptrreplace) = @_;
  my @thesefiles = @$ptrfiles;
  my @replace = @$ptrreplace;
  Cwd::chdir($dir);

  for (my $i=0; $i < @thesefiles; $i++) {   
    while (my $file=<$thesefiles[$i]>) {    	

      if ($top == 0) {
        open (OUTPUT, ">>$file") or die "Could not open output file: $file \n";
        if(@replace > 0){ print OUTPUT @replace;}
        else {while (<STDIN>) {print OUTPUT $_;}}
      }
      else {
        open (OUTPUT, ">$file.XX") or die "Could not open output file: $file.XX \n";
        open (INFILE, "<$file") or die "Could not open input file: $file \n";
        if(@replace > 0){ print OUTPUT @replace;}
        else {while (<STDIN>) {print OUTPUT $_;}}
        while (my $line=<INFILE>) {print OUTPUT $line;}
        rename( "${file}.XX", "${file}") || die "Could not rename ${file}.XX to ${file}.\n";
      }				
      if ($verbose == 1) {
        print "successfully appended text to $file...\n"  
      }
    } #end while
  } #end for
	
  if ($recursive == 1) {
    $dir = getcwd;

    #opens directory $dir to variable DIR 	
    opendir DIR,$dir || die "Cannot open $dir: $!\n";
    # "grep -d", returns all items from DIR, that are directories
    # "grep !/^\./,", returns all items from DIR, that did not start with a dot
    #                 removes "." and ".."
    my @dirs = grep -d, grep !/^\./, readdir(DIR);
    # close directory DIR
    closedir DIR;

    while (my $newDir=shift @dirs) {
      &append($newDir,$verbose,$ptrfiles,$ptrreplace);
    }
  }
}

# for recursive functions open file just once 
sub getBlock {
  my ($file) = @_;
  my (@lines); 
  open(IN, $file) or die "Could not open in file: $file";
  while (<IN>) {
    push(@lines, $_);
  }
  close(IN);

  return @lines;
}

sub Usage {
  die "Appends text to a file at the end or on top.",
    "Usage:\n  append.pl \n",
    "-r                 recursive replace through all sub directories\n",
    "-d <directory>     directory\n",
    "-f <filename,...>  filenames to search in (mandatory)\n",
    "-b <filename>      containing text to insert (mandatory or -r)\n",
    "-v                 verbose\n\n",    
    "Example:\n",
    "1. echo Hallo | append.pl -f test.txt\n",
    "   appends hallo to test.txt\n",
    "2. append.pl -f test.txt < cat append.txt\n",
    "or append.pl -f test.txt -b append.txt\n",
    "   appends content off append.txt to test.txt\n",
    "3. append.pl -f \"*.cc\" -b append.txt -r\n",
    "   appends content off append.txt to all *.cc files in current and sub\n",
    "   directories\n";
}
