#!/usr/bin/perl

use strict;
use Getopt::Std;
use Cwd;

my $arg;
my $recursive = 0;
my $dir = getcwd;
my @replace=();
my $sensitive = 0;
my @search=();
my @buffer;
my $func_name = "";
my $verbose = 0;
my $file = "";

while ($arg = shift @ARGV) {
  #print $arg, "\n";
  if ($arg =~ /^-R$/g) { $recursive = 1;}  #recursive
  if ($arg =~ /^-e$/g) { $sensitive = 1;} #case sensitive replacement
  if ($arg =~ /^-v$/g) { $verbose = 1;}  #verbose output
  if ($arg =~ /^-d$/g) { $dir = shift @ARGV;}  #directory
  if ($arg =~ /^-r$/g) { push(@replace, shift @ARGV);} #replace
  if ($arg =~ /^-b$/g) { @replace = getBlock(shift @ARGV);} #replace with entire block from file
  if ($arg =~ /^-a$/g) { @search = getSearchBlock(shift @ARGV);} #search block from file
  if ($arg =~ /^-m$/g) { $func_name = shift @ARGV;}  #function or sub name
  if ($arg =~ /^-s$/g) { push(@search, shift @ARGV);} #search string
  if ($arg =~ /^-f$/g) { $file = shift @ARGV;} #file to search in
}
my @files=split(/,/,$file);

&Usage unless (length($dir) > 0);
&Usage unless (length($file) > 0) && ($#search >= 0) && ($#replace >= 0);

if ($verbose == 1) {
  print (($sensitive == 1) ? "case sensitive replacement\n" : "case insensitive replacement\n");

  if ($recursive == 1) {
    print "Recursive replacement \n";
  }

  if (length($func_name) > 0) {
    print "replace in function=$func_name\n" ;
  }
  print "Directory $dir \n";
  print "Search @search \n";
  print "Replace @replace \n";
  print "Files @files \n\n";
  print "Running... \n\n";
}

#start and end tag of a function
my $func_start="\\s*Sub\\s+${func_name}|\\s*Function\\s+${func_name}";
my $func_end="\\s*End\\s+Function|\\s*End\\s+Sub";

&search_n_replace($sensitive,$dir,\@search,\@files,\@replace);

sub search_n_replace {
  my ($sensitive,$dir,$ptrsearch,$ptrfiles,$ptrreplace) = @_;
  my @thesefiles = @$ptrfiles;
  my @search = @$ptrsearch;
  my @replace = @$ptrreplace;
  Cwd::chdir($dir);
		
  for (my $i=0; $i < @thesefiles; $i++) {
    while (my $file=<$thesefiles[$i]>) {
      open(IN,$file) or die "Could not open in file: $file.$$ \n";
      open(OUT,">$file.$$") or die "Could not open out file: $file.$$ \n";
      my $changed = 0;
      my $line;
      my $found = 0;

      if($#search == 0) {
        #if search for single words is performed, then a 
        #"multi search and replace" per row is allowed
        my $infunc = 0;  #if = 1 we are in the search function
        while (<IN>) {
          if(length($func_name) > 0) {
            if ($infunc == 1) {
              /${func_end}/gi && ($infunc = 0); # && print "End sub or end function single \n";
            } else {
              /${func_start}/gi && ($infunc = 1);# && print "in sub or function single \n";              
            }
          }
          if (($infunc == 1) || (length($func_name) == 0)) {
            (($sensitive == 1) ? s/@search/@replace/g : s/@search/@replace/gi) &&  ($changed = 1) && print "$file - Changed @search to @replace\n";
          }
          print OUT;
        }
      }
      else {  #more than 1 line to search for
        my $infunc = 0;  #if = 1 we are in the search function
        #search for single or multiple complete rows
        while($line = <IN>) {
          if(length($func_name) > 0) {
            if ($infunc == 1) {
              if ($line =~ /${func_end}/gi) {
                $infunc = 0;
                #print "End sub or end function multiple \n";
              }
            } else {
              if ($line =~ /${func_start}/gi) {
                $infunc = 1;
                #print "in sub or function multiple \n"; 
              }             
            }
          }
          my $inSearchPart = 0;
          if (($infunc == 1) || (length($func_name) == 0)) {
            #print $line, @search[$found], "\n", $found; 
            if($line eq @search[$found]) {
              $inSearchPart = 1;
              $found++;
              push(@buffer,$line);
              if($found == ($#search+1)) {
                $changed = 1;
                print OUT @replace;
                if($verbose == 1) {
                  print "Found:\n @search\n";
                  print "Replace with:\n @replace\n";
                }	
                @buffer = (); #cleans the array 
                $found = 0;
              } 
            }
          }
          if ($inSearchPart == 0) { #we are no longer in the function or in found part
            if ($found <=> 0) { 
              $found = 0;
              print OUT @buffer;
              print OUT $line;
              @buffer = (); #cleans the array 
            } else {
              print OUT $line;
            }
          }
        }  #while
      } #else
      close(IN);
      close(OUT);
      ($changed==1) ? rename("$file.$$",$file) : unlink "$file.$$";
    } #while
  } #for
  
  if ($recursive == 1) {
    #dir = pwd
    $dir = getcwd;

    #opens directory $dir to variable DIR 	
    opendir DIR,$dir || die "Cannot open $dir: $!\n";
    # "grep -d", returns all items from DIR, that are directories
    # "grep !/^\./,", returns all items from DIR, that did not start with a dot
    #                 removes "." and ".."
    my @dirs = grep -d, grep !/^\./, readdir(DIR);
    #my @dirs = grep -d "$dir/$_", map "$_", grep !/^\./, readdir(DIR);
    # close directory DIR
    closedir DIR;

    while (my $newDir=shift @dirs) {
      print "checking $newDir\n";
      &search_n_replace($sensitive,$newDir,$ptrsearch,$ptrfiles,$ptrreplace);
    }
  }
	
} #function

# for recursive functions open file just once 
sub getBlock {
  my ($file) = @_;
  my (@lines); 
  open(IN, $file) or die "Could not open in file: $file";
  while (<IN>) {
    push(@lines, $_);
  }
  close(IN);

  return @lines;
}

sub getSearchBlock {
  my ($file) = @_;
  my (@lines); 
  open(IN, $file) or die "Could not open in file: $file";
  while (<IN>) {
    push(@lines, $_);
  }
  close(IN);
  return @lines;
}

sub Usage {
  die "Replaces text in a file.\n",
    "Usage:\n  replace.pl \n", 
    "-R                 recursive replace through all sub directories\n",
    "-d <directory>     directory\n",
    "-f <filename,...>  filenames to search in (mandatory)\n",
    "-s <search>        search string (mandatory or -a) regular expression multi\n", 
    "                   search and replace\n",
    "-a <filename>      containing text to search for (mandatory or -s) line comparison nor\n",
    "                   regular expressions will be used\n",
    "-r <replace>       replace with this string (mandatory or -b)\n",
    "-b <filename>      containing text to insert (mandatory or -r)\n",
    "-e                 case sensitive search\n",
    "-m <function name> perform search only in a block limited by begin and end tag,\n",
    "                   right now full signature of begin and end is hard coded\n",
    "-v                 verbose\n\n",
    "Search strings are regular expressions and all occurences will be replaced, if\n",
    "search values come from a file\n",
    "Option a and b search for complete lines, there is no need to mask special characters\n",
    "and the last line needs a line break.\n\n",
    "Exampel:\n",
    "1: replace.pl -R -d src -f \"*.cc\" -a search.txt -b replace.txt\n",
    "   searches in directory \"./src\" and all sub directories for files \"*.cc\" with\n",
    "   content of \"serach.txt\" and replaces it with content of \"replace.txt\"\n",
    "2: replace2.pl -f test.frm -s \"lubahn\" -r \"dirk\" -m\"test\"\n",
    "   searches in file \"test.frm\" in function \"test\" for \"lubahn\" and replaces it\n",
    "   with \"dirk\" only in that function\n";
}
